## Bundled FFmpeg binaries

Place platform-specific `ffmpeg` and `ffprobe` binaries in the folders below so the desktop app can run audio synchronization completely offline.

```
electron/vendor/ffmpeg/
├── mac/
│   ├── ffmpeg
│   └── ffprobe
├── win/
│   ├── ffmpeg.exe
│   └── ffprobe.exe
└── linux/
    ├── ffmpeg
    └── ffprobe
```

### Recommended builds

- **macOS**: [FFmpeg static builds by BtbN](https://github.com/BtbN/FFmpeg-Builds/releases) (`ffmpeg-master-latest-macos64-gpl`).
- **Windows**: [Gyan FFmpeg builds](https://www.gyan.dev/ffmpeg/builds/) (`ffmpeg-release-essentials.zip`).
- **Linux**: Use your distribution's static build or compile from source with `--enable-gpl`.

Copy the downloaded binaries into the appropriate platform folder and ensure they are executable (`chmod +x ffmpeg ffprobe` on macOS/Linux). When packaging, these binaries are copied automatically so the feature works without requiring a system-level FFmpeg install.









