# FFmpeg Setup Instructions

## Quick Setup (macOS)

### Option 1: Using Homebrew (Recommended)
```bash
brew install ffmpeg
cp $(brew --prefix ffmpeg)/bin/ffmpeg electron/vendor/ffmpeg/mac/
cp $(brew --prefix ffmpeg)/bin/ffprobe electron/vendor/ffmpeg/mac/
chmod +x electron/vendor/ffmpeg/mac/ffmpeg electron/vendor/ffmpeg/mac/ffprobe
```

### Option 2: Manual Download

1. Download FFmpeg static build for macOS:
   - Visit: https://evermeet.cx/ffmpeg/
   - Download `ffmpeg` and `ffprobe` (or use the zip archive)

2. Or use BtbN builds:
   - Visit: https://github.com/BtbN/FFmpeg-Builds/releases
   - Download `ffmpeg-master-latest-macos64-gpl.zip`
   - Extract and copy `bin/ffmpeg` and `bin/ffprobe` to `electron/vendor/ffmpeg/mac/`

3. Make binaries executable:
   ```bash
   chmod +x electron/vendor/ffmpeg/mac/ffmpeg
   chmod +x electron/vendor/ffmpeg/mac/ffprobe
   ```

### Option 3: Direct Download Script
Run this from the project root:
```bash
cd electron/vendor/ffmpeg/mac
curl -L -o ffmpeg.zip "https://evermeet.cx/ffmpeg/getrelease/ffmpeg/zip"
unzip -j ffmpeg.zip ffmpeg
curl -L -o ffprobe.zip "https://evermeet.cx/ffmpeg/getrelease/ffprobe/zip"
unzip -j ffprobe.zip ffprobe
chmod +x ffmpeg ffprobe
rm -f ffmpeg.zip ffprobe.zip
```

## Verify Installation

After setup, verify the binaries work:
```bash
electron/vendor/ffmpeg/mac/ffmpeg -version
electron/vendor/ffmpeg/mac/ffprobe -version
```

Both commands should output version information without errors.









